//TabView demo
#include <Application.h>
#include <Window.h>
#include <string.h>

#include "TabView.h"
#include "Colors.h"

class GenericApp : public BApplication
{
	public:
		GenericApp();
		~GenericApp();
};

class GenericWindow : public BWindow
{
	public:
		GenericWindow();
		~GenericWindow();
};

class DemoView: public BView
{
	public:
		DemoView(BRect frame, int32 ViewNumber);
		~DemoView();
		void Draw(BRect updateRect);
	private:
		char String[15];
};

int main()
{
	new GenericApp;
	be_app->Run();
	delete be_app;
}

GenericApp::GenericApp()
: BApplication("application/x-vnd.BT-Generic")
{
	new GenericWindow;
}

GenericApp::~GenericApp()
{ }

GenericWindow::~GenericWindow()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
}

GenericWindow::GenericWindow()
: BWindow(BRect(50,50,450,450),"Generic test window",B_TITLED_WINDOW,0)
{
	BView* TabbedViews[4];
	const char* TabNames[4] = {"View 1","View 2","View 3","View 4"};
	TabView* DemoTabView = new TabView(Bounds(),NULL,TabNames,4,B_FOLLOW_ALL_SIDES);
	BRect ContentRect = DemoTabView->GetContentArea();
	for(int Counter = 0; Counter < 4; Counter++)
		TabbedViews[Counter] = new DemoView(ContentRect,Counter);
	DemoTabView->AddViews(TabbedViews);
	AddChild(DemoTabView);
	Show();
}

DemoView::DemoView(BRect frame,int32 Counter)
: BView(frame,NULL,B_FOLLOW_ALL_SIDES,B_WILL_DRAW)
{
	strcpy(String,"This is view X");
	String[13] = Counter + '1';
	SetViewColor(BeBackgroundGrey);
	SetHighColor(Black);
	SetLowColor(BeBackgroundGrey);
	SetDrawingMode(B_OP_OVER);
}

DemoView::~DemoView()
{ }

void DemoView::Draw(BRect UpdateRect)
{
	DrawString(String,BPoint(20.0,35.0));
}